------------------------------------------------------------------------------
--                       JAZZ Spawn table                     --
------------------------------------------------------------------------------

SpawnUnits = {}

SpawnUnits[UN] = {}
--
SpawnUnits[UN].Leaders 	= {}
SpawnUnits[UN].Snipers 	= {}
SpawnUnits[UN].Guards 	= {}
SpawnUnits[UN].Soldiers 	= {}
SpawnUnits[UN].Elite 		= {}

SpawnUnits[UN].Leaders = 
{
	Phase_0 =
	{
		"un_white_male_lead"
	},
	
	Phase_1 =
	{
		"un_white_male_lead"
	},
	
	Phase_2 = 
	{
		"un_white_male_lead"
	},
	
	Phase_3 = 
	{
		"un_white_male_lead"
	},
	
	Phase_4 = 
	{
		"un_white_male_lead"
	}
}

SpawnUnits[UN].Soldiers = 
{
	Phase_0 =
	{
		"un_white_male_01",
		"un_black_male_01"
	},
	
	Phase_1 = 
	{
		"un_white_male_01",
		"un_black_male_01"
	},

	Phase_2 = 
	{
		"un_white_male_01",
		"un_black_male_01"
	},
	
	Phase_3 = 
	{
		"un_white_male_01",
		"un_black_male_01"
	},
	
	Phase_4 = 
	{
		"un_white_male_01",
		"un_black_male_01"
	}
}

SpawnUnits[UN].Guards = 
{
	Phase_0 = 
	{
		"un_white_male_01",
		"un_black_male_01"
	},
	
	Phase_1 = 
	{
		"un_white_male_01",
		"un_black_male_01"
	},
	
	Phase_2 = 
	{
		"un_white_male_01",
		"un_black_male_01"
	},
	
	Phase_3 = 
	{
		"un_white_male_01",
		"un_black_male_01"
	},
	
	Phase_4 = 
	{
		"un_white_male_01",
		"un_black_male_01"
	}
}

SpawnUnits[UN].Snipers = 
{
	Phase_0 = 
	{
		"un_white_male_officer_01",
		"un_white_male_sniper_01"
	},

	Phase_1 = 
	{
		"un_white_male_officer_01",
		"un_white_male_sniper_01"
	},

	Phase_2 = 
	{
		"un_white_male_officer_01",
		"un_white_male_sniper_01"
	},

	Phase_3 = 
	{
		"un_white_male_officer_01",
		"un_white_male_sniper_01"
	},

	Phase_4 = 
	{
		"un_white_male_officer_01",
		"un_white_male_sniper_01"
	}
}

------------------------------------------------------------------------------
SpawnUnits[REBELS] = {}
--
SpawnUnits[REBELS].Leaders 	= {}
SpawnUnits[REBELS].Snipers 	= {}
SpawnUnits[REBELS].Guards 	= {}
SpawnUnits[REBELS].Soldiers 	= {}
SpawnUnits[REBELS].Elite 		= {}
--
SpawnUnits[REBELS].Leaders = 
{
	Phase_0 =
	{
		"militia_officer_01",
		"militia_officer_02"
	},
	
	Phase_1 =
	{
		"militia_officer_01",
		"militia_officer_02"
	},
	
	Phase_2 = 
	{
		"regular_officer_01",
		"regular_officer_02"
	},
	
	Phase_3 = 
	{
		"regular_officer_01",
		"regular_officer_02"
	},
	
	Phase_4 = 
	{
		"guard_officer_01",
		"guard_officer_02"
	}
}
--
SpawnUnits[REBELS].Soldiers = 
{
	Phase_0 =
	{
		"militia_strong",
		"militia_normal"
	},
	
	Phase_1 = 
	{
		"militia_strong",
		"militia_strong_02",
		"militia_normal"
	},

	Phase_2 = 
	{
		"regular_strong",
		"regular_normal"
	},
	
	Phase_3 = 
	{
		"regular_strong",
		"regular_strong_02",
		"regular_normal"
	},
	
	Phase_4 = 
	{
		"guard_strong",
		"guard_strong_02",
		"guard_normal"
	}
}
--
SpawnUnits[REBELS].Guards = 
{
	Phase_0 = 
	{
		"militia_weak",
		"militia_weak_02"
	},
	
	Phase_1 = 
	{
		"militia_normal_02",
		"militia_weak"
	},
	
	Phase_2 = 
	{
		"regular_weak",
		"regular_weak_02"
	},
	
	Phase_3 = 
	{
		"regular_normal_02",
		"regular_weak"
	},
	
	Phase_4 = 
	{
		"guard_normal_02",
		"guard_weak",
		"guard_weak_02"
	}
}
--
SpawnUnits[REBELS].Snipers = 
{
	Phase_0 = 
	{
		"militia_sniper"
	},
	
	Phase_1 = 
	{
		"militia_sniper"
	},
	
	Phase_2 = 
	{
		"regular_sniper"
	},
	
	Phase_3 = 
	{
		"regular_sniper"
	},
	
	Phase_4 = 
	{
		"guard_sniper"
	}
}
------------------------------------------------------------------------------
SpawnUnits[ARMY] = {}
--
SpawnUnits[ARMY].Leaders 	= {}
SpawnUnits[ARMY].Snipers 	= {}
SpawnUnits[ARMY].Guards 	= {}
SpawnUnits[ARMY].Soldiers 	= {}
SpawnUnits[ARMY].Elite 		= {}
--
SpawnUnits[ARMY].Leaders = 
{
	Phase_0 =
	{
		"militia_officer_01",
		"militia_officer_02"
	},
	
	Phase_1 =
	{
		"militia_officer_01",
		"militia_officer_02"
	},
	
	Phase_2 = 
	{
		"regular_officer_01",
		"regular_officer_02"
	},
	
	Phase_3 = 
	{
		"regular_officer_01",
		"regular_officer_02"
	},
	
	Phase_4 = 
	{
		"guard_officer_01",
		"guard_officer_02"
	}
}
--
SpawnUnits[ARMY].Soldiers = 
{
	Phase_0 =
	{
		"militia_strong",
		"militia_normal"
	},
	
	Phase_1 = 
	{
		"militia_strong",
		"militia_strong_02",
		"militia_normal"
	},

	Phase_2 = 
	{
		"regular_strong",
		"regular_normal"
	},
	
	Phase_3 = 
	{
		"regular_strong",
		"regular_strong_02",
		"regular_normal"
	},
	
	Phase_4 = 
	{
		"guard_strong",
		"guard_strong_02",
		"guard_normal"
	}
}
--
SpawnUnits[ARMY].Guards = 
{
	Phase_0 = 
	{
		"militia_weak",
		"militia_weak_02"
	},
	
	Phase_1 = 
	{
		"militia_normal_02",
		"militia_weak"
	},
	
	Phase_2 = 
	{
		"regular_weak",
		"regular_weak_02"
	},
	
	Phase_3 = 
	{
		"regular_normal_02",
		"regular_weak"
	},
	
	Phase_4 = 
	{
		"guard_normal_02",
		"guard_weak",
		"guard_weak_02"
	}
}
--
SpawnUnits[ARMY].Snipers = 
{
	Phase_0 = 
	{
		"militia_sniper"
	},
	
	Phase_1 = 
	{
		"militia_sniper"
	},
	
	Phase_2 = 
	{
		"regular_sniper"
	},
	
	Phase_3 = 
	{
		"regular_sniper"
	},
	
	Phase_4 = 
	{
		"guard_sniper"
	}
}
--
SpawnUnits[CORP] = {}
--
SpawnUnits[CORP].Leaders 	= {}
SpawnUnits[CORP].Snipers 	= {}
SpawnUnits[CORP].Guards 	= {}
SpawnUnits[CORP].Soldiers 	= {}
SpawnUnits[CORP].Elite 		= {}
--
SpawnUnits[CORP].Leaders = 
{
	Phase_0 =
	{
		"corp_white_male_lead_01",
		"corp_white_male_lead_02"
	},
	
	Phase_1 =
	{
		"corp_white_male_lead_01",
		"corp_white_male_lead_02"
	},
	
	Phase_2 = 
	{
		"corp_white_male_lead_01",
		"corp_white_male_lead_02"
	},
	
	Phase_3 = 
	{
		"corp_white_male_lead_01",
		"corp_white_male_lead_02"
	},
	
	Phase_4 = 
	{
		"corp_white_male_lead_01",
		"corp_white_male_lead_02"
	}
}
--
SpawnUnits[CORP].Soldiers = 
{
	Phase_0 =
	{
		"corp_white_male_01",
		"corp_white_male_02"
	},
	
	Phase_1 = 
	{
		"corp_white_male_01",
		"corp_white_male_02"
	},

	Phase_2 = 
	{
		"corp_white_male_01",
		"corp_white_male_02"
	},
	
	Phase_3 = 
	{
		"corp_white_male_01",
		"corp_white_male_02"
	},
	
	Phase_4 = 
	{
		"corp_white_male_01",
		"corp_white_male_02"
	}
}
--
SpawnUnits[CORP].Guards = 
{
	Phase_0 = 
	{
		"corp_white_male_01",
		"corp_white_male_02"
	},
	
	Phase_1 = 
	{
		"corp_white_male_01",
		"corp_white_male_02"
	},
	
	Phase_2 = 
	{
		"corp_white_male_01",
		"corp_white_male_02"
	},
	
	Phase_3 = 
	{
		"corp_white_male_01",
		"corp_white_male_02"
	},
	
	Phase_4 = 
	{
		"corp_white_male_01",
		"corp_white_male_02"
	}
}
--
SpawnUnits[CORP].Snipers = 
{
	Phase_0 = 
	{
		"corp_white_male_sniper_01"
	},
	
	Phase_1 = 
	{
		"corp_white_male_sniper_01"
	},
	
	Phase_2 = 
	{
		"corp_white_male_sniper_01",
		"corp_white_male_sniper_02"
	},
	
	Phase_3 = 
	{
		"corp_white_male_sniper_01",
		"corp_white_male_sniper_02"
	},
	
	Phase_4 = 
	{
		"corp_white_male_sniper_01",
		"corp_white_male_sniper_02"
	}
}
--
SpawnUnits[BUTSI] = {}
--
SpawnUnits[BUTSI].Leaders 	= {}
SpawnUnits[BUTSI].Snipers 	= {}
SpawnUnits[BUTSI].Guards 	= {}
SpawnUnits[BUTSI].Soldiers 	= {}
SpawnUnits[BUTSI].Elite 		= {}
--
SpawnUnits[BUTSI].Leaders = 
{
	Phase_0 =
	{
		"butsi_soldier_01",
		"butsi_soldier_02",
		"butsi_soldier_03",
		"butsi_soldier_04",
		"butsi_soldier_05"
	},
	
	Phase_1 =
	{
		"butsi_soldier_01",
		"butsi_soldier_02",
		"butsi_soldier_03",
		"butsi_soldier_04",
		"butsi_soldier_05"
	},
	
	Phase_2 = 
	{
		"butsi_soldier_01",
		"butsi_soldier_02",
		"butsi_soldier_03",
		"butsi_soldier_04",
		"butsi_soldier_05"
	},
	
	Phase_3 = 
	{
		"butsi_soldier_01",
		"butsi_soldier_02",
		"butsi_soldier_03",
		"butsi_soldier_04",
		"butsi_soldier_05"
	},
	
	Phase_4 = 
	{
		"butsi_soldier_01",
		"butsi_soldier_02",
		"butsi_soldier_03",
		"butsi_soldier_04",
		"butsi_soldier_05"
	}
}
--
SpawnUnits[BUTSI].Soldiers = 
{
	Phase_0 =
	{
		"butsi_soldier_01",
		"butsi_soldier_02",
		"butsi_soldier_03",
		"butsi_soldier_04",
		"butsi_soldier_05"
	},
	
	Phase_1 = 
	{
		"butsi_soldier_01",
		"butsi_soldier_02",
		"butsi_soldier_03",
		"butsi_soldier_04",
		"butsi_soldier_05"
	},

	Phase_2 = 
	{
		"butsi_soldier_01",
		"butsi_soldier_02",
		"butsi_soldier_03",
		"butsi_soldier_04",
		"butsi_soldier_05"
	},
	
	Phase_3 = 
	{
		"butsi_soldier_01",
		"butsi_soldier_02",
		"butsi_soldier_03",
		"butsi_soldier_04",
		"butsi_soldier_05"
	},
	
	Phase_4 = 
	{
		"butsi_soldier_01",
		"butsi_soldier_02",
		"butsi_soldier_03",
		"butsi_soldier_04",
		"butsi_soldier_05"
	}
}
--
SpawnUnits[BUTSI].Guards = 
{
	Phase_0 = 
	{
		"butsi_soldier_01",
		"butsi_soldier_02",
		"butsi_soldier_03",
		"butsi_soldier_04",
		"butsi_soldier_05"
	},
	
	Phase_1 = 
	{
		"butsi_soldier_01",
		"butsi_soldier_02",
		"butsi_soldier_03",
		"butsi_soldier_04",
		"butsi_soldier_05"
	},
	
	Phase_2 = 
	{
		"butsi_soldier_01",
		"butsi_soldier_02",
		"butsi_soldier_03",
		"butsi_soldier_04",
		"butsi_soldier_05"
	},
	
	Phase_3 = 
	{
		"butsi_soldier_01",
		"butsi_soldier_02",
		"butsi_soldier_03",
		"butsi_soldier_04",
		"butsi_soldier_05"
	},
	
	Phase_4 = 
	{
		"butsi_soldier_01",
		"butsi_soldier_02",
		"butsi_soldier_03",
		"butsi_soldier_04",
		"butsi_soldier_05"
	}
}
--
SpawnUnits[BUTSI].Snipers = 
{
	Phase_0 = 
	{
		"butsi_soldier_01",
		"butsi_soldier_02",
		"butsi_soldier_03",
		"butsi_soldier_04",
		"butsi_soldier_05"
	},
	
	Phase_1 = 
	{
		"butsi_soldier_01",
		"butsi_soldier_02",
		"butsi_soldier_03",
		"butsi_soldier_04",
		"butsi_soldier_05"
	},
	
	Phase_2 = 
	{
		"butsi_soldier_01",
		"butsi_soldier_02",
		"butsi_soldier_03",
		"butsi_soldier_04",
		"butsi_soldier_05"
	},
	
	Phase_3 = 
	{
		"butsi_soldier_01",
		"butsi_soldier_02",
		"butsi_soldier_03",
		"butsi_soldier_04",
		"butsi_soldier_05"
	},
	
	Phase_4 = 
	{
		"butsi_soldier_01",
		"butsi_soldier_02",
		"butsi_soldier_03",
		"butsi_soldier_04",
		"butsi_soldier_05"
	}
}
--
SpawnUnits[MARAUDERS] = {}
--
SpawnUnits[MARAUDERS].Leaders 	= {}
SpawnUnits[MARAUDERS].Snipers 	= {}
SpawnUnits[MARAUDERS].Guards 	= {}
SpawnUnits[MARAUDERS].Soldiers 	= {}
SpawnUnits[MARAUDERS].Elite 	= {}
--
SpawnUnits[MARAUDERS].Leaders = 
{
	Phase_0 =
	{
		"mar_officer_01",
		"mar_officer_02"
	},
	
	Phase_1 =
	{
		"mar_officer_01",
		"mar_officer_02"
	},
	
	Phase_2 = 
	{
		"mar_officer_01",
		"mar_officer_02"
	},
	
	Phase_3 = 
	{
		"mar_officer_01",
		"mar_officer_02"
	},
	
	Phase_4 = 
	{
		"mar_officer_01",
		"mar_officer_02"
	}
}
--
SpawnUnits[MARAUDERS].Soldiers = 
{
	Phase_0 = 
	{
		"mar_weak",
		"mar_weak_02"
	},
	
	Phase_1 = 
	{
		"mar_weak_02",
		"mar_weak",
		"mar_normal"
	},
	
	Phase_2 = 
	{
		"mar_normal",
		"mar_normal_02"
	},
	
	Phase_3 = 
	{
		"mar_black_male_01",
		"mar_black_male_02",
		"mar_white_male_01",
		"mar_white_female_01"
	},
	
	Phase_4 = 
	{
		"mar_black_male_01",
		"mar_black_male_02",
		"mar_white_male_01",
		"mar_white_female_01",
		"mar_black_male_01_camo",
		"mar_white_male_01_camo",
		"mar_white_male_02_camo",
		"mar_white_female_01_camo"
	}
}
--
SpawnUnits[MARAUDERS].Guards = 
{
	Phase_0 = 
	{
		"mar_weak",
		"mar_weak_02"
	},
	
	Phase_1 = 
	{
		"mar_weak_02",
		"mar_weak",
		"mar_normal"
	},
	
	Phase_2 = 
	{
		"mar_normal",
		"mar_normal_02"
	},
	
	Phase_3 = 
	{
		"mar_normal",
		"mar_normal_02",
		"mar_strong"
	},
	
	Phase_4 = 
	{
		"mar_strong",
		"mar_strong_02"
	}
}
--
SpawnUnits[MARAUDERS].Snipers = 
{
	Phase_0 = 
	{
		"mar_sniper"
	},
	
	Phase_1 = 
	{
		"mar_sniper",
		"mar_black_male_sniper"
	},
	
	Phase_2 = 
	{
		"mar_black_male_sniper"
	},
	
	Phase_3 = 
	{
		"mar_black_male_sniper",
		"mar_white_male_sniper"
	},
	
	Phase_4 = 
	{
		"mar_white_male_sniper"
	}
}
--
SpawnUnits[PIRATS] = {}
--
SpawnUnits[PIRATS].Leaders 	= {}
SpawnUnits[PIRATS].Snipers 	= {}
SpawnUnits[PIRATS].Guards 	= {}
SpawnUnits[PIRATS].Soldiers 	= {}
SpawnUnits[PIRATS].Elite 	= {}
--
SpawnUnits[PIRATS].Leaders = 
{
	Phase_0 =
	{
		"mar_officer_01",
		"mar_officer_02"
	},
	
	Phase_1 =
	{
		"mar_officer_01",
		"mar_officer_02"
	},
	
	Phase_2 = 
	{
		"mar_officer_01",
		"mar_officer_02"
	},
	
	Phase_3 = 
	{
		"mar_officer_01",
		"mar_officer_02"
	},
	
	Phase_4 = 
	{
		"mar_officer_01",
		"mar_officer_02"
	}
}
--
SpawnUnits[PIRATS].Soldiers = 
{
	Phase_0 = 
	{
		"mar_weak",
		"mar_weak_02"
	},
	
	Phase_1 = 
	{
		"mar_weak_02",
		"mar_weak",
		"mar_normal"
	},
	
	Phase_2 = 
	{
		"mar_normal",
		"mar_normal_02"
	},
	
	Phase_3 = 
	{
		"mar_black_male_01",
		"mar_black_male_02",
		"mar_white_male_01",
		"mar_white_female_01"
	},
	
	Phase_4 = 
	{
		"mar_black_male_01",
		"mar_black_male_02",
		"mar_white_male_01",
		"mar_white_female_01",
		"mar_black_male_01_camo",
		"mar_white_male_01_camo",
		"mar_white_male_02_camo",
		"mar_white_female_01_camo"
	}
}
--
SpawnUnits[PIRATS].Guards = 
{
	Phase_0 = 
	{
		"mar_weak",
		"mar_weak_02"
	},
	
	Phase_1 = 
	{
		"mar_weak_02",
		"mar_weak",
		"mar_normal"
	},
	
	Phase_2 = 
	{
		"mar_normal",
		"mar_normal_02"
	},
	
	Phase_3 = 
	{
		"mar_normal",
		"mar_normal_02",
		"mar_strong"
	},
	
	Phase_4 = 
	{
		"mar_strong",
		"mar_strong_02"
	}
}
--
SpawnUnits[PIRATS].Snipers = 
{
	Phase_0 = 
	{
		"mar_sniper"
	},
	
	Phase_1 = 
	{
		"mar_sniper",
		"mar_black_male_sniper"
	},
	
	Phase_2 = 
	{
		"mar_black_male_sniper"
	},
	
	Phase_3 = 
	{
		"mar_black_male_sniper",
		"mar_white_male_sniper"
	},
	
	Phase_4 = 
	{
		"mar_white_male_sniper"
	}
}
--
Spawn =
{
	spawned = 0,

	soldier =
	{
		sysname = "wolf",
		behavior = "squaddy",
		behavior_arg = "banda",
		specialization = "soldier",
		dialog = "Guide",
		things = "e1s_patrol_01,e1s_patrol_02,e1s_patrol_03",
		pose = "stand",
		power = 4
	},
	officer =
	{
		sysname = "mar_officer_01",
		behavior = "squaddy",
		behavior_arg = "banda",
		specialization = "soldier",
		dialog = "Guide",
		things = "e1s_patrol_01,e1s_patrol_02,e1s_patrol_03",
		pose = "lie",
		power = 6
	},
	palace_def_officer =
	{
		sysname = "regular_officer_01",
		behavior = "squad_leader",
		behavior_arg = "reinforce",
		specialization = "soldier",
		dialog = "",
		things = "e4s_officer_03",
		pose = "stand",
		power = 6
	},
	palace_def_solider =
	{
		sysname = "regular_strong",
		behavior = "squaddy",
		behavior_arg = "reinforce",
		specialization = "soldier",
		dialog = "",
		things = "e4s_soldier_01",
		pose = "stand",
		power = 6
	},
	butsi_militia_01 =
    {
		sysname = "butsi_soldier_01",
		behavior = "free",
		behavior_arg = "",
		specialization = "soldier",
		dialog = "butsi_militia",
		things = "e1s_soldier_01",
		pose = "stand",
		power = 3
    },
	butsi_militia_02 =
    {
		sysname = "butsi_soldier_02",
		behavior = "free",
		behavior_arg = "",
		specialization = "soldier",
		dialog = "butsi_militia",
		things = "e1s_soldier_01",
		pose = "stand",
		power = 3
    },
	butsi_militia_03 =
    {
		sysname = "butsi_soldier_03",
		behavior = "free",
		behavior_arg = "",
		specialization = "soldier",
		dialog = "butsi_militia",
		things = "e1s_soldier_01",
		pose = "stand",
		power = 3
    },
	butsi_militia_04 =
    {
		sysname = "butsi_soldier_04",
		behavior = "free",
		behavior_arg = "",
		specialization = "soldier",
		dialog = "butsi_militia",
		things = "e1s_soldier_01",
		pose = "stand",
		power = 3
    },
	butsi_militia_05 =
    {
		sysname = "butsi_soldier_05",
		behavior = "free",
		behavior_arg = "",
		specialization = "soldier",
		dialog = "butsi_militia",
		things = "e1s_soldier_01",
		pose = "stand",
		power = 3
    },
 	marauder_militia_01 =
    {
		sysname = "mar_weak",
		behavior = "free",
		behavior_arg = "",
		specialization = "soldier",
		dialog = "marauder_militia",
		things = "e3s_soldier_01",
		pose = "stand",
		power = 5
    },
 	marauder_militia_02 =
    {
		sysname = "mar_normal",
		behavior = "free",
		behavior_arg = "",
		specialization = "soldier",
		dialog = "marauder_militia",
		things = "e3s_soldier_01",
		pose = "stand",
		power = 5
    },
 	marauder_militia_03 =
    {
		sysname = "mar_strong",
		behavior = "free",
		behavior_arg = "",
		specialization = "soldier",
		dialog = "marauder_militia",
		things = "e3s_soldier_01",
		pose = "stand",
		power = 5
    },
 	dictator_militia_01 =
    {
		sysname = "guard_weak",
		behavior = "free",
		behavior_arg = "",
		specialization = "soldier",
		dialog = "dictator_militia",
		things = "e4s_soldier_01",
		pose = "stand",
		power = 7
    },
 	dictator_militia_02 =
    {
		sysname = "guard_normal",
		behavior = "free",
		behavior_arg = "",
		specialization = "soldier",
		dialog = "dictator_militia",
		things = "e4s_soldier_01",
		pose = "stand",
		power = 7
    },
 	dictator_militia_03 =
    {
		sysname = "guard_strong",
		behavior = "free",
		behavior_arg = "",
		specialization = "soldier",
		dialog = "dictator_militia",
		things = "e4s_soldier_01",
		pose = "stand",
		power = 7
    },
 	corp_militia_01 =
    {
		sysname = "corp_white_male_01",
		behavior = "free",
		behavior_arg = "",
		specialization = "soldier",
		dialog = "corp_militia",
		things = "e4s_soldier_01",
		pose = "stand",
		power = 7
    },
 	corp_militia_02 =
    {
		sysname = "corp_white_male_02",
		behavior = "free",
		behavior_arg = "",
		specialization = "soldier",
		dialog = "corp_militia",
		things = "e4s_soldier_01",
		pose = "stand",
		power = 7
    },
 	corp_militia_03 =
    {
		sysname = "corp_white_male_lead_01",
		behavior = "free",
		behavior_arg = "",
		specialization = "soldier",
		dialog = "corp_militia",
		things = "e4s_soldier_01",
		pose = "stand",
		power = 7
    },
 	pir_black_male_01 =
    {
		sysname = "pir_black_male_01",
		behavior = "free",
		behavior_arg = "",
		specialization = "soldier",
		dialog = "",
		things = "pir_strong_set_01",
		pose = "stand",
		power = 7
    },
 	pir_white_male_01 =
    {
		sysname = "pir_white_male_01",
		behavior = "free",
		behavior_arg = "",
		specialization = "soldier",
		dialog = "",
		things = "pir_strong_set_02",
		pose = "stand",
		power = 7
    },
 	pir_officer_01 =
    {
		sysname = "pir_officer_01",
		behavior = "free",
		behavior_arg = "",
		specialization = "soldier",
		dialog = "",
		things = "pir_officer_set_01",
		pose = "stand",
		power = 7
    },
 	dog_white_male_01 =
    {
		sysname = "dog_white_male_01",
		behavior = "free",
		behavior_arg = "",
		specialization = "soldier",
		dialog = "",
		things = "enemy_elite_set_01",
		pose = "stand",
		power = 7
    },
 	dog_white_male_lead_01 =
    {
		sysname = "dog_white_male_lead_01",
		behavior = "free",
		behavior_arg = "",
		specialization = "soldier",
		dialog = "",
		things = "enemy_officer_set_01",
		pose = "stand",
		power = 7
    }
}
--
SpawnAreas = {}
--
function generateSpawnAreas()
	
	local generate = function(sector, data)
		SpawnAreas[sector] = {}
		log("spawn_test", sector)
		fillSpawnAreas(sector)
	end
	
	table.foreach(Sectors, generate)
end
--
function fillSpawnAreas(sector)
	local p = { getMissionPlayers(sector) }
	
	if not(isValid(sector)) then
		return
	end
	
	local fill = function(index, side)
		if (isValid(side)) then
			local spawnSize = getSpawnSize(sector, side)
			local s = {}
			
			log("spawn_test", ">", side)			
			log("spawn_test", ">> spawnSize", spawnSize)
			
			for count = 1, spawnSize, 1 do
				local area = getSpawnName(sector, side, count)
				log("spawn_test", ">>>", count, "area", area)
				table.insert(s, area)
			end
			
			SpawnAreas[sector][side] 			= {}
			SpawnAreas[sector][side].All 		= s
			SpawnAreas[sector][side].Sniper 	= {}
			SpawnAreas[sector][side].Guard 		= {}
			SpawnAreas[sector][side].Leader 	= {}
			SpawnAreas[sector][side].Ambush 	= {}
			SpawnAreas[sector][side].Soldier	= {}
			SpawnAreas[sector][side].Undefined	= {}
			
			local sort = function(index, area)
			
				if (isValid(area)) then
					if (string.find(area, "sniper_")) then
						table.insert(SpawnAreas[sector][side].Sniper, area)
					elseif (string.find(area, "guard_")) then
						table.insert(SpawnAreas[sector][side].Guard, area)
					elseif (string.find(area, "leader_")) then
						table.insert(SpawnAreas[sector][side].Leader, area)
					elseif (string.find(area, "ambush_")) then
						table.insert(SpawnAreas[sector][side].Ambush, area)
					elseif (string.find(area, "soldier_")) then
						table.insert(SpawnAreas[sector][side].Soldier, area)
					else
						table.insert(SpawnAreas[sector][side].Undefined, area)
					end
				end
				
				if (side == PLAYER) then
					activateSpawn(sector, side, area, false)
				end
				
			end
			
			table.foreach(s, sort)
		end
	end
	
	table.foreach(p, fill)
end
--
